// File: CEG_Video.hpp
// Version: 1.1
// Author: Loyalguard
// Description: Define dialog classes and related controls for the CEG CCTV child dialog of the grid control system.

class CEG_Video
{
	
	idd = 20800;
	movingEnable = false;
	
	controlsBackground[] = 
	{
		
	};
	
	objects[] = { };
	
	controls[] = 
	{
		CEG_WindowHeaderRect,
		CEG_WindowHeaderText,
		CEG_WindowIconPicture,
		
		CEG_WindowClosePicture,
		CEG_WindowCloseActive,
		
		CEG_WindowFooterText,
		
		CEG_CamLabelStaticText,

		CEG_Cam1Button,		
		CEG_Cam2Button,		
		CEG_Cam3Button,				
		CEG_Cam4Button,		
		CEG_Cam5Button,		
		CEG_Cam6Button,		
		CEG_Cam7Button,		
		CEG_ReturnButton		
	};

	// BACKGROUND CONTROL CLASSES //

	// CONTROL CLASSES //

	// GUI Window Controls

	class CEG_WindowHeaderRect : CEG_Window
	{
		x = (safeZoneX + (safeZoneW * 0));
		y = (safeZoneY + (safeZoneH * 0));
		w = (safeZoneW * 1);
		h = (safeZoneH * 0.05);
		colorBackground[] = CEG_COLOR_BLUE;
	};

	class CEG_WindowHeaderText : CEG_Window
	{
		x = (safeZoneX + (safeZoneW * 0.035));
		y = (safeZoneY + (safeZoneH * 0));
		w = (safeZoneW * 0.75);
		h = (safeZoneH * 0.05);
		style = ST_LEFT;		
		colorText[] = CEG_COLOR_WHITE;
		colorBackground[] = CEG_COLOR_CLEAR;
		text = "Chernarus Electrical Grid Transmission and Distribution System - South Zagoria Region";
	};

	class CEG_WindowFooterText : CEG_Window
	{
		idc = 20801;
		x = (safeZoneX + (safeZoneW * 0));
		y = (safeZoneY + (safeZoneH * 0.95));
		w = (safeZoneW * 1);
		h = (safeZoneH * 0.05);
		style = ST_LEFT;
		text = "Click a button to switch to that camera.  Click RETURN to return to System Overview Screen";
	};

	class CEG_WindowIconPicture : CEG_StaticPicture
	{
		style = ST_PICTURE + ST_KEEP_ASPECT_RATIO;
		x = (safeZoneX + (safeZoneW * 0));
		y = (safeZoneY + (safeZoneH * 0));
		w = (safeZoneW * 0.03);
		h = (safeZoneH * 0.05);
		text = "CEG\Textures\WindowIcon.paa";
	};

	class CEG_WindowClosePicture : CEG_StaticPicture
	{
		default = true;
		style = ST_PICTURE + ST_KEEP_ASPECT_RATIO;
		x = (safeZoneX + (safeZoneW * 0.965));
		y = (safeZoneY + (safeZoneH * 0));
		w = (safeZoneW * 0.03);
		h = (safeZoneH * 0.05);
		text = "CEG\Textures\CloseButton.paa";
	};
	
	class CEG_WindowCloseActive : CEG_ActiveText
	{
		idc = -1;
		x = (safeZoneX + (safeZoneW * 0.965));
		y = (safeZoneY + (safeZoneH * 0));
		w = (safeZoneW * 0.03);
		h = (safeZoneH * 0.05);
		color[] = CEG_COLOR_CLEAR;
		colorActive[] = CEG_COLOR_CLEAR;
		action = "closeDialog 20800;";
		text = "   ";
	};
	
	class CEG_CamLabelStaticText : CEG_StaticText
	{
		idc = 20802;
		style = ST_LEFT;
		x = (safeZoneX + (safeZoneW * 0));
		y = (safeZoneY + (safeZoneH * 0.050));
		w = (safeZoneW * 0.75);
		h = (safeZoneH * 0.1);
		colorText[] = CEG_COLOR_LTGRAY;
		colorBackground[] = CEG_COLOR_CLEAR;
		SizeEX = 0.04;
		text = "";
	};
	
	 class CEG_Cam1Button : CEG_Button
	{
		idc = 20810;
		x = (safeZoneX + (safeZoneW * 0));
		y = (safeZoneY + (safeZoneH * 0.875));
		w = (safeZoneW *  0.125);
		h = (safeZoneH * 0.075);
		action = "[""P_Elek""] spawn CEG_fnc_video;";
		text = "01 - Elek";
  };
  
	class CEG_Cam2Button : CEG_Button
	{
		idc = 20811;
		x = (safeZoneX + (safeZoneW * 0.125));
		y = (safeZoneY + (safeZoneH * 0.875));
		w = (safeZoneW * 0.125);
		h = (safeZoneH * 0.075);
		action = "[""SZag""] spawn CEG_fnc_video;";
		text = "02 - SZag";
  };
  
	class CEG_Cam3Button : CEG_Button
	{
		idc = 20812;
		x = (safeZoneX + (safeZoneW * 0.25));
		y = (safeZoneY + (safeZoneH * 0.875));
		w = (safeZoneW * 0.125);
		h = (safeZoneH * 0.075);
		action = "[""Soln""] spawn CEG_fnc_video;";
		text = "03 - Soln";
  };
  
	class CEG_Cam4Button : CEG_Button
	{
		idc = 20813;
		x = (safeZoneX + (safeZoneW * 0.375));
		y = (safeZoneY + (safeZoneH * 0.875));
		w = (safeZoneW * 0.125);
		h = (safeZoneH * 0.075);
		action = "[""D_Cher""] spawn CEG_fnc_video;";
		text = "04 - DCher";
  };
  
	class CEG_Cam5Button : CEG_Button
	{
		idc = 20814;
		x = (safeZoneX + (safeZoneW * 0.5));
		y = (safeZoneY + (safeZoneH * 0.875));
		w = (safeZoneW * 0.125);
		h = (safeZoneH * 0.075);
		action = "[""P_Cher""] spawn CEG_fnc_video;";
		text = "05 - PCher";
	};
  
	class CEG_Cam6Button : CEG_Button
	{
		idc = 20815;
		x = (safeZoneX + (safeZoneW * 0.625));
		y = (safeZoneY + (safeZoneH * 0.875));
		w = (safeZoneW * 0.125);
		h = (safeZoneH * 0.075);
		action = "[""Zele""] spawn CEG_fnc_video;";
		text = "06 - Zele";
  };
  
	class CEG_Cam7Button : CEG_Button
	{
		idc = 20816;
		x = (safeZoneX + (safeZoneW * 0.75));
		y = (safeZoneY + (safeZoneH * 0.875));
		w = (safeZoneW *  0.125);
		h = (safeZoneH * 0.075);
		action = "[""Bere""] spawn CEG_fnc_video;";
		text = "07 - Bere";
	};
  
	class CEG_ReturnButton : CEG_Button
	{
		idc = -1;
		x = (safeZoneX + (safeZoneW * 0.875));
		y = (safeZoneY + (safeZoneH * 0.875));
		w = (safeZoneW * 0.125);
		h = (safeZoneH * 0.075);
		text = "RETURN";
		action = "closeDialog 20800;";
  };
	
};